#!/bin/bash

AIOWPM_URL="https://github.com/d0n601/All-In-One-WP-Migration-With-Import/archive/master.zip"

function install_wp {
  DB_NAME="${USER}_$(openssl rand -hex 4)"
  DB_PASSWORD="$(openssl rand -hex 8)"
  WP_ADMIN_USER="$(openssl rand -hex 4)"
  WP_ADMIN_PASSWORD="$(openssl rand -hex 8)"

  echo "> Creating database: ${DB_NAME}"
  uapi Mysql create_database name="${DB_NAME}"
  echo "> Creating database user: ${DB_NAME} [ ${DB_PASSWORD} ]"
  uapi Mysql create_user name="${DB_NAME}" password="${DB_PASSWORD}"
  echo "> Granting database privilleges"
  uapi Mysql set_privileges_on_database user="${DB_NAME}" database="${DB_NAME}" privileges=ALL

  echo "> Downloading core"
  wp core download
  echo "> Creating wp-config.php"
  wp config create --dbname="${DB_NAME}" --dbuser="${DB_NAME}" --dbpass="${DB_PASSWORD}"
  echo "> Populating database with WP Admin user: ${WP_ADMIN_USER} [ ${WP_ADMIN_PASSWORD} ]"
  wp core install --url="${DOMAIN}" --title="${DOMAIN}" --admin_user="${WP_ADMIN_USER}" --admin_password="${WP_ADMIN_PASSWORD}" --admin_email="test@${DOMAIN}"
}

#php -v | grep -q 'PHP 7.' || { echo "! Please set PHP to 7.X"; exit 1; }

if [[ ! -f "${PWD}/wp-config.php" ]]; then
  echo "! No WordPress installation found in ${PWD}"
  read -rp "> Do you want to install a new WordPress installation in ${PWD}? [y/n]: " WP_CHOICE
  [[ "${WP_CHOICE}" != "y" ]] && { echo "! No confirmation received"; exit 1; }
  read -rp "> Enter the domain name: " DOMAIN
  [[ -z "${DOMAIN}" ]] && { echo "! No domain name provided"; exit 1; }
  install_wp
fi

BACKUPS=($(find "${PWD}" -type f -name "*.wpress"))
[[ -z "${BACKUPS}" ]] && { echo "! No .wpress backups found within ${PWD}"; exit 1; }

if [[ "${#BACKUPS[@]}" -gt 1 ]]; then
  NUM=1
  for i in "${BACKUPS[@]}"; do
    echo "${NUM}. $i"
    NUM=$((NUM+1))
  done | column -t

  read -rp "> Choose the number: " BACKUP_CHOICE
  [[ ! "${BACKUP_CHOICE}" =~ ^[1-9]{1}[0-9]*$ ]] && { echo "! Invalid choice"; exit 1; }
  ARRAY_MAPPER=$((BACKUP_CHOICE-1))
  [[ -z "${BACKUPS[${ARRAY_MAPPER}]}" ]] && { echo "! Invalid choice"; exit 1; }
  BACKUP_PATH="${BACKUPS[${ARRAY_MAPPER}]}"

else
  BACKUP_PATH="${BACKUPS}"
fi

echo "> Selected backup: ${BACKUP_PATH}"

read -rp "> Do you want to proceed? [y/n]: " CHOICE
[[ ! "${CHOICE}" =~ ^[yY](es)?$ ]] && { echo "! Ok, next time"; exit 1; }

BACKUP="$(awk -F/ '{print $NF}' <<<"${BACKUP_PATH}")"
DIRNAME="$(dirname "${BACKUP_PATH}")"
AI1WM_PATH="${PWD}/wp-content/ai1wm-backups"

if [[ "${DIRNAME}" != "${AI1WM_PATH}" ]]; then
  mkdir -p "${AI1WM_PATH}"
  mv "${BACKUP_PATH}" "${AI1WM_PATH}"
fi

if [[ -d "${PWD}/wp-content/plugins/all-in-one-wp-migration" ]]; then
  echo "> Removing original all-in-one-wp-migration plugin"
  wp plugin delete all-in-one-wp-migration
fi

echo "> Downloading forked all-in-one-wp-migration plugin"
wget -qP "${PWD}/wp-content/plugins" "${AIOWPM_URL}" || { echo "Failed to download ${AIOWPM_URL}"; exit 1; }

echo "> Installing forked all-in-one-wp-migration plugin"
unzip -q "${PWD}/wp-content/plugins/master.zip" -d "${PWD}/wp-content/plugins" || { echo "Failed to extract ${PWD}/wp-content/plugins/master.zip"; exit 1; }
mv "${PWD}/wp-content/plugins/All-In-One-WP-Migration-With-Import-master" "${PWD}/wp-content/plugins/all-in-one-wp-migration"
rm -f "${PWD}/wp-content/plugins/master.zip"
# raise to 128 GB instead of default 32
# sed -i 's/34359738368/137438953472/' "${PWD}/wp-content/plugins/all-in-one-wp-migration/constants.php"

echo "> Activating forked all-in-one-wp-migration plugin"
mkdir -p "${PWD}/wp-content/ai1wm-backups"
wp plugin activate all-in-one-wp-migration

echo "> Atempting to restore backup ${BACKUP_PATH}"
wp ai1wm restore "${BACKUP}"

echo "> Updating all-in-one-wp-migration plugin"
wp plugin update all-in-one-wp-migration

echo "> Configuring .htaccess"
echo -e 'apache_modules:\n  - mod_rewrite' > "${HOME}/.wp-cli/config.yml"
wp rewrite flush --hard
