<?php
/**
 * Include the TGM_Plugin_Activation class.
 */

require_once trailingslashit( PENCI_SOLEDAD_DIR ) . 'inc/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'penci_register_required_plugins' );
if ( ! function_exists( 'penci_register_required_plugins' ) ) {
	function penci_register_required_plugins() {
		$link_server = apply_filters( 'penci_plugins_server', 'https://s3.amazonaws.com/soledad-plugins/' );
		$plugins = array(
			array(
				'name'     => 'Penci Shortcodes & Performance',
				'slug'     => 'penci-shortcodes',
				'source'   => $link_server . 'penci-shortcodes.zip',
				'required' => true,
				'version'  => '6.0',
			),
			array(
				'name'     => 'Penci Text To Speech',
				'slug'     => 'penci-text-to-speech',
				'optional' => true,
				'source'   => $link_server . 'penci-text-to-speech.zip',
				'required' => false,
				'version'  => '1.6',
			),
			array(
				'name'     => 'Vafpress Post Formats UI',
				'slug'     => 'vafpress-post-formats-ui-develop',
				'source'   => $link_server . 'vafpress-post-formats-ui-develop.zip',
				'required' => false,
				'version'  => '1.8',
			),
			array(
				'name'     => 'Elementor Page Builder',
				'slug'     => 'elementor',
				'required' => true,
				'version'  => '',
			),
			array(
				'name'     => 'Penci Slider',
				'slug'     => 'penci-soledad-slider',
				'source'   => $link_server . 'penci-soledad-slider.zip',
				'optional' => true,
				'required' => false,
				'version'  => '1.1',
			),
			array(
				'name'     => 'Penci Portfolio',
				'slug'     => 'penci-portfolio',
				'source'   => $link_server . 'penci-portfolio.zip',
				'required' => false,
				'version'  => '3.5',
			),
			array(
				'name'     => 'Penci Recipe',
				'slug'     => 'penci-recipe',
				'source'   => $link_server . 'penci-recipe.zip',
				'required' => false,
				'version'  => '4.0',
			),
			array(
				'name'     => 'Penci Review',
				'slug'     => 'penci-review',
				'source'   => $link_server . 'penci-review.zip',
				'required' => false,
				'version'  => '3.5',
			),
			array(
				'name'     => 'Penci Soledad Demo Importer',
				'slug'     => 'penci-soledad-demo-importer',
				'source'   => $link_server . 'penci-soledad-demo-importer.zip',
				'required' => false,
				'version'  => '5.6',
			),
			array(
				'name'     => 'Penci Soledad Data Migrator',
				'optional' => true,
				'slug'     => 'penci-data-migrator',
				'source'   => $link_server . 'penci-data-migrator.zip',
				'required' => false,
				'version'  => '1.2',
			),
			array(
				'name'     => 'Penci Social Feed',
				'optional' => true,
				'slug'     => 'penci-tiktok-twitter-feed',
				'source'   => $link_server . 'penci-tiktok-twitter-feed.zip',
				'required' => false,
				'version'  => '1.1',
			),
			array(
				'name'     => 'Penci Frontend Submission',
				'optional' => true,
				'slug'     => 'penci-frontend-submission',
				'source'   => $link_server . 'penci-frontend-submission.zip',
				'required' => false,
				'version'  => '1.7',
			),
			array(
				'name'     => 'Penci Paywall',
				'optional' => true,
				'slug'     => 'penci-paywall',
				'source'   => $link_server . 'penci-paywall.zip',
				'required' => false,
				'version'  => '2.3',
			),
			array(
				'name'     => 'Penci Pay Writer',
				'optional' => true,
				'slug'     => 'penci-pay-writer',
				'source'   => $link_server . 'penci-pay-writer.zip',
				'required' => false,
				'version'  => '1.4',
			),
			array(
				'name'     => 'Penci RSS Aggregator',
				'optional' => true,
				'slug'     => 'penci-feeds',
				'source'   => $link_server . 'penci-feeds.zip',
				'required' => false,
				'version'  => '1.3',
			),
			array(
				'name'     => 'Penci Podcast',
				'optional' => true,
				'slug'     => 'penci-podcast',
				'source'   => $link_server . 'penci-podcast.zip',
				'required' => false,
				'version'  => '1.4',
			),
			array(
				'name'     => 'Penci AI SmartContent Creator',
				'optional' => true,
				'slug'     => 'penci-ai',
				'source'   => $link_server . 'penci-ai.zip',
				'required' => false,
				'version'  => '1.9',
			),
			array(
				'name'     => 'Penci Bookmark & Follow',
				'optional' => true,
				'slug'     => 'penci-bookmark-follow',
				'source'   => $link_server . 'penci-bookmark-follow.zip',
				'required' => false,
				'version'  => '2.0',
			),
			array(
				'name'     => 'Penci Finance',
				'optional' => true,
				'slug'     => 'penci-finance',
				'source'   => $link_server . 'penci-finance.zip',
				'required' => false,
				'version'  => '1.4',
			),
			array(
				'name'     => 'Penci Sport',
				'optional' => true,
				'slug'     => 'penci-sport',
				'source'   => $link_server . 'penci-sport.zip',
				'required' => false,
				'version'  => '1.2',
			),
			array(
				'name'     => 'Penci Smart Crop Thumbnails',
				'optional' => true,
				'slug'     => 'penci-smart-crop-thumbnails',
				'source'   => $link_server . 'penci-smart-crop-thumbnails.zip',
				'required' => false,
				'version'  => '1.2',
			),
			array(
				'name'     => 'Penci Live Blog',
				'optional' => true,
				'slug'     => 'penci-liveblog',
				'source'   => $link_server . 'penci-liveblog.zip',
				'required' => false,
				'version'  => '1.3',
			),
			array(
				'name'     => 'Penci Google Analytics Views',
				'optional' => true,
				'slug'     => 'penci-ga-views',
				'source'   => $link_server . 'penci-ga-views.zip',
				'required' => false,
				'version'  => '1.1',
			),
			array(
				'name'     => 'Penci Mobile Templates',
				'optional' => true,
				'slug'     => 'penci-mobile-templates',
				'source'   => $link_server . 'penci-mobile-templates.zip',
				'required' => false,
				'version'  => '1.2',
			),
			array(
				'name'     => 'Penci Filter Everything',
				'optional' => true,
				'slug'     => 'penci-filter-everything',
				'source'   => $link_server . 'penci-filter-everything.zip',
				'required' => false,
				'version'  => '1.6',
			),
			array(
				'name'     => 'Penci Player Rankings',
				'optional' => true,
				'slug'     => 'penci-player-rankings',
				'source'   => $link_server . 'penci-player-rankings.zip',
				'required' => false,
				'version'  => '1.0',
			),
			array(
				'name'     => 'Contact Form 7',
				'slug'     => 'contact-form-7',
				'required' => false,
				'version'  => '',
			),
			array(
				'name'     => 'MailChimp for WordPress',
				'slug'     => 'mailchimp-for-wp',
				'required' => false,
				'version'  => '',
			),
			array(
				'name'     => 'Penci Soledad AMP',
				'optional' => true,
				'slug'     => 'penci-soledad-amp',
				'source'   => $link_server . 'penci-soledad-amp.zip',
				'required' => false,
				'version'  => '5.3',
			),
			array(
				'name'     => 'HubSpot - All-in-One Marketing',
				'slug'     => 'leadin',
				'required' => false,
				'version'  => '',
			),
		);
		$config  = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => '',
			'is_automatic' => true,
			'message'      => '',
		);

		tgmpa( $plugins, $config );
	}
}