<?php
/**
 * Template part for Slider Style 27
 */

$feat_query = penci_get_query_featured_slider();
if ( ! $feat_query ) {
	return;
}
$slider_title_length = get_theme_mod( 'penci_slider_title_length' ) ? get_theme_mod( 'penci_slider_title_length' ) : 12;
$image_size          = get_theme_mod( 'featured_slider_imgsize' ) ? get_theme_mod( 'featured_slider_imgsize' ) : 'penci-thumb';
$image_size_big      = get_theme_mod( 'featured_slider_imgbig' ) ? get_theme_mod( 'featured_slider_imgbig' ) : 'penci-magazine-slider';

$image_msize = get_theme_mod( 'featured_slider_imgsize_mobile' ) ? get_theme_mod( 'featured_slider_imgsize_mobile' ) : 'penci-masonry-thumb';

?>
<?php if ( $feat_query->have_posts() ) : ?>
    <div class="item swiper-slide">
        <div class="wrapper-item wrapper-item-classess">
			<?php $i   = 1;
			$num_posts = $feat_query->post_count;
			while ( $feat_query->have_posts() ) : $feat_query->the_post();
				$thumb = $image_size;
				if ( $i % 5 == 1 ): $thumb = $image_size_big; endif;
				$sizep = 'small';
				if ( $i % 5 == 1 ): $sizep = 'normal'; endif;
				?>
                <div class="penci-item-mag penci-item-<?php echo( $i % 5 ); ?>">
					<?php do_action( 'penci_bookmark_post', get_the_ID(), $sizep ); ?>
					<?php if ( ! get_theme_mod( 'penci_disable_lazyload_slider' ) ) { ?>
                        <a class="penci-image-holder <?php echo penci_classes_slider_lazy(); ?>"
                           data-bgset="<?php echo penci_image_srcset( get_the_ID(), $thumb, $image_msize ); ?>"
                           href="<?php the_permalink(); ?>"
                           title="<?php echo wp_strip_all_tags( get_the_title() ); ?>"></a>
					<?php } else { ?>
                        <a class="penci-image-holder"
                           style="background-image: url('<?php echo penci_get_featured_image_size( get_the_ID(), penci_is_mobile() ? $image_msize : $thumb ); ?>');"
                           href="<?php the_permalink(); ?>"
                           title="<?php echo wp_strip_all_tags( get_the_title() ); ?>"></a>
					<?php } ?>

                    <div class="penci-slide-overlay penci-slider6-overlay">
                        <a class="overlay-link"
                           aria-label="<?php echo wp_strip_all_tags( get_the_title() ); ?>"
                           href="<?php the_permalink(); ?>"></a>
						<?php if ( ! get_theme_mod( 'penci_featured_slider_icons' ) && ( has_post_format( 'video' ) || has_post_format( 'audio' ) || has_post_format( 'link' ) || has_post_format( 'quote' ) || has_post_format( 'gallery' ) ) ): ?>
                            <a href="<?php the_permalink(); ?>" class="overlay-icon-format">
								<?php if ( has_post_format( 'video' ) ) : ?>
									<?php penci_fawesome_icon( 'fas fa-play' ); ?>
								<?php endif; ?>
								<?php if ( has_post_format( 'audio' ) ) : ?>
									<?php penci_fawesome_icon( 'fas fa-music' ); ?>
								<?php endif; ?>
								<?php if ( has_post_format( 'link' ) ) : ?>
									<?php penci_fawesome_icon( 'fas fa-link' ); ?>
								<?php endif; ?>
								<?php if ( has_post_format( 'quote' ) ) : ?>
									<?php penci_fawesome_icon( 'fas fa-quote-left' ); ?>
								<?php endif; ?>
								<?php if ( has_post_format( 'gallery' ) ) : ?>
									<?php penci_fawesome_icon( 'far fa-image' ); ?>
								<?php endif; ?>
                            </a>
						<?php endif; ?>
                        <div class="penci-mag-featured-content">
                            <div class="feat-text<?php if ( get_theme_mod( 'penci_featured_meta_date' ) ): echo ' slider-hide-date'; endif; ?>">
								<?php if ( ! get_theme_mod( 'penci_featured_hide_categories' ) && get_theme_mod( 'penci_featured_show_categories' ) ): ?>
                                    <div class="cat featured-cat"><?php penci_category( '' ); ?></div>
								<?php endif; ?>
                                <h3><a title="<?php echo wp_strip_all_tags( get_the_title() ); ?>"
                                       href="<?php the_permalink() ?>"><?php echo wp_trim_words( wp_strip_all_tags( get_the_title() ), $slider_title_length, '...' ); ?></a>
                                </h3>
								<?php if ( ! get_theme_mod( 'penci_featured_meta_comment' ) || ! get_theme_mod( 'penci_featured_meta_date' ) || get_theme_mod( 'penci_featured_meta_author' ) ): ?>
                                    <div class="feat-meta">
										<?php if ( get_theme_mod( 'penci_featured_meta_author' ) ): ?>
                                            <span class="feat-author"><?php echo penci_get_setting( 'penci_trans_by' ); ?> <a
                                                        href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
										<?php endif; ?>
										<?php if ( ! get_theme_mod( 'penci_featured_meta_date' ) ): ?>
                                            <span class="feat-time"><?php penci_soledad_time_link(); ?></span>
										<?php endif; ?>
										<?php if ( ! get_theme_mod( 'penci_featured_meta_comment' ) ): ?>
                                            <span class="feat-comments"><a
                                                        href="<?php comments_link(); ?> "><?php comments_number( '0 ' . penci_get_setting( 'penci_trans_comments' ), '1 ' . penci_get_setting( 'penci_trans_comment' ), '% ' . penci_get_setting( 'penci_trans_comments' ) ); ?></a></span>
										<?php endif; ?>
										<?php do_action( 'penci_extra_meta' ); ?>
                                    </div>
								<?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

				<?php if ( $i % 5 == 0 && $i > 1 && $i < $num_posts ): echo '</div></div><div class="item swiper-slide"><div class="wrapper-item wrapper-item-classess">'; endif; ?>

				<?php $i ++; endwhile;
			wp_reset_postdata(); ?>
        </div>
    </div>
<?php endif; ?>
